<?php
/**
 * Created by PhpStorm.
 * User: Maxim
 * Date: 03.11.2015
 * Time: 22:09
 */

$url = "http://stat";

$mb = new TransportMikBiLL();

$parser = new Parser();
$methodName = $parser->getMethod($mb);

if ($methodName) {
    $param = $parser->getParam();
    $mb->_url = $url;
    $mb->$methodName($param);
} else {
    echo "Method unknown";
}


class Parser
{
    public function getMethod($class)
    {
        if ($_SERVER["argc"] > 1) {

            $methodName = $_SERVER["argv"][1];

            if (method_exists($class, $methodName)) {
                return $methodName;
            }
        }

        return false;
    }

    public function getParam()
    {
        $data = $_SERVER["argv"];

        unset($data[0], $data[1]);

        $r = implode(" ", $data);
        $param = explode("-", $r);

        $response = array();

        foreach ($param as $item) {
            if (!empty($item)) {
                $key_value = explode(" ", $item);
                $response[trim($key_value[0])] = trim($key_value[1]);
            }
        }

        return $response;
    }
}


class TransportMikBiLL
{

    public $_url;
    public $_cookieAuth = 'empty';

    private $_uid;

    private $_billLink = array(
        'authfl'        => '/ajax/index/authfl',
        'getcreditflex' => '/ajax/users/getcreditflex',
        'usevaucherfl'  => '/ajax/users/usevaucherfl'
    );

    public function do_pay_card($data)
    {
        if ($this->doAuthMB($data['login'], $data['pass'])) {

            if (!empty($data['card'])) {

                if ($this->doVaucher($data['card'])) {
                    echo "Success pay_card";
                } else {
                    echo "Err pay_card";
                }
            } else {
                echo "Empty card";
            }
        } else {
            echo "No auth";
        }
    }

    public function do_credit_enable($data)
    {
        if ($this->doAuthMB($data['login'], $data['pass'])) {
            if ($this->doCredit($data['pass'])) {
                echo "Success do_credit_enable";
            } else {
                echo "Err do_credit_enable";
            }
        } else {
            echo "No auth";
        }
    }

    private function doVaucher($code)
    {
        $arrayVaucher = str_split($code, 4);

        $card1 = (isset($arrayVaucher[0]) ? $arrayVaucher[0] : '');
        $card2 = (isset($arrayVaucher[1]) ? $arrayVaucher[1] : '');
        $card3 = (isset($arrayVaucher[2]) ? $arrayVaucher[2] : '');
        $card4 = (isset($arrayVaucher[3]) ? $arrayVaucher[3] : '');
        $card5 = (isset($arrayVaucher[4]) ? $arrayVaucher[4] : '');

        $url = $this->_url . $this->_billLink['usevaucherfl'];

        $param = "card1=" . $card1 . "&card2=" . $card2 . "&card3=" . $card3 . "&card4=" . $card4 . "&card5=" . $card5;

        $responseQuery = $this->sendQuery($url, 'post', $param, 0);
        $bufferResponse = $this->xmlParser2($responseQuery);

        if (isset($bufferResponse['ok']) AND $bufferResponse['ok'] == '1') {
            return true;
        } else {
            return false;
        }
    }

    public function doAuthMB($login, $pass)
    {
        $url = $this->_url . $this->_billLink['authfl'];
        $param = "password=" . $pass . "&login=" .  $login;
        $responseQuery = $this->sendQuery($url, 'post', $param, 1);

        $valueCookie = $this->parserCookie($responseQuery);
        $this->setCookie($valueCookie);

        $statusAuth = $this->xmlParser2($responseQuery);
		
        if (isset($statusAuth['user'][0]['enable'], $statusAuth['user'][0]['us_uid']) AND $statusAuth['user'][0]['enable'] == '1') {
            $this->_uid = $statusAuth['user'][0]['us_uid'];

            return true;
        } else {
            return false;
        }
    }

    public function doCredit($pass)
    {
        $url = $this->_url . $this->_billLink['getcreditflex'];

        $param = "oldpass=" . $pass . "&uid=" . $this->_uid;
        $responseQuery = $this->sendQuery($url, 'post', $param, 0);
        $buferRespone = $this->xmlParser2($responseQuery);

        if (isset($buferRespone['ok']) AND $buferRespone['ok'] == '1') {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Транспорт запросов на BackEnd MikBILL
     *
     * @param $url
     * @param $postGet
     * @param $param
     * @param int $paramCookie
     * @return mixed
     */
    public function sendQuery($url, $postGet, $param, $paramCookie = 0)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_REFERER, 'https://mikbill.ru');

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);

        curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (Windows; U; Windows NT 5.0; En; rv:1.8.0.2) Gecko/20070306 Firefox/1.0.0.4");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, true);

        // Параметры Cookie. 0-работать со старыми. 1-получить новые
        if ($paramCookie == 0) {
            curl_setopt($curl, CURLOPT_HEADER, 0);
            curl_setopt($curl, CURLOPT_COOKIE, "PHPSESSID=" . $this->_cookieAuth);
        } else {
            curl_setopt($curl, CURLOPT_HEADER, 1);
        }

        if ($postGet == 'post') {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $param);
        }

        $result = curl_exec($curl);
        curl_close($curl);

        return $result;
    }


    /**
     * Function: xml2array
     * Description: Parse XML data into an array structure
     *
     * @param $input_xml
     * @return array
     */
    public function xmlParser2($input_xml)
    {
        $array = Array();
        $reg_exp = '/<(\w+)[^>]*>(.*?)<\/\\1>/s';

        preg_match_all($reg_exp, $input_xml, $match);

        foreach ($match[1] as $key => $val) {
            if (preg_match($reg_exp, $match[2][$key])) {
                $array[$val][] = $this->xmlParser2($match[2][$key]);
            } else {
                $array[$val] = html_entity_decode($match[2][$key]);
            }
        }

        return $array;
    }


    /**
     * Парсер куков
     *
     * @param $input
     * @return null
     */
    public function parserCookie($input)
    {
        preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $input, $cookies);

        if (isset($cookies[1][0])) {
            $valueCookie = explode('=', $cookies[1][0]);

            return $valueCookie['1'];
        } else {
            return null;
        }
    }


    /**
     * Установка куков в браузере
     *
     * @param $name
     */
    public function setCookie($name)
    {
        $this->_cookieAuth = $name;
        SetCookie("PHPSESSID", $name, time() + 3600);
    }

    /**
     * Удаление куков
     */
    public function delCookie()
    {
        SetCookie("PHPSESSID", '');
    }
}